/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ConnectionManager;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.Heartbeat;
import com.ibm.hwmca.fw.connmgr.HeartbeatListener;
import com.ibm.hwmca.fw.util.HMCTimer;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerParms;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Map;

public class HeartbeatMonitor
implements HMCTimerTask,
ConnectionConstants {
    private static final String THIS_CLASS = "HeartbeatMonitor";
    private static HeartbeatMonitor MONITOR = null;
    private Map _heartMap = new HashMap();
    private Map _pendingAddListeners = new HashMap();

    public static HeartbeatMonitor getHeartbeatMonitor() {
        if (MONITOR == null) {
            MONITOR = new HeartbeatMonitor();
            HMCTimer timer = HMCTimer.getHMCTimer();
            TimerParms parms = new TimerParms(0L, 20000L, true);
            timer.schedule((HMCTimerTask)MONITOR, parms);
        }
        return MONITOR;
    }

    private HeartbeatMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TimerTaskExecutionControl timerTaskExecutionControl, Object runParms) {
        Trace.trace("HSSLCONF", "--> HeartbeatMonitor.run");
        Map map = this._heartMap;
        synchronized (map) {
            Object[] hearts = this._heartMap.values().toArray();
            Heartbeat heart = null;
            for (int i = 0; i < hearts.length; ++i) {
                heart = (Heartbeat)hearts[i];
                try {
                    heart.beatOnce();
                    continue;
                }
                catch (Exception e) {
                    Trace.trace("HSSLCONF", "HeartbeatMonitor.run:  ", e);
                    this._heartMap.remove(heart.getClientId());
                    heart.cleanUp();
                }
            }
        }
        Trace.trace("HSSLCONF", "<-- HeartbeatMonitor.run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Heartbeat getHeartbeatForClient(ContextId clientId) {
        Map map = this._heartMap;
        synchronized (map) {
            return (Heartbeat)this._heartMap.get(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGroup(ConnectionGroup group) {
        Trace.trace("HSSLCONF", "--> HeartbeatMonitor.addGroup, client:  " + group.getClientID());
        Heartbeat heart = null;
        try {
            Map map = this._heartMap;
            synchronized (map) {
                if (this._heartMap.containsKey(group.getClientID())) {
                    heart = (Heartbeat)this._heartMap.get(group.getClientID());
                    heart.cleanUp();
                    heart = new Heartbeat(group, heart.getListeners());
                } else {
                    heart = new Heartbeat(group);
                }
                this._heartMap.put(heart.getClientId(), heart);
                HeartbeatListener pendingListener = (HeartbeatListener)this._pendingAddListeners.remove(group.getClientID());
                if (pendingListener != null) {
                    this.addListenerForClient(group.getClientID(), pendingListener);
                }
            }
        }
        catch (Exception e) {
            ConnectionManager.logException(e, (short)2098);
            Trace.trace("HSSLCONF", "HeartbeatMonitor.addGroup:  ", e);
        }
        Trace.trace("HSSLCONF", "<-- HeartbeatMonitor.addGroup, new heartbeat is " + heart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerForClient(ContextId clientId, HeartbeatListener listener) {
        Trace.trace("HSSLCONF", "--> HeartbeatMonitor.addListenerForClient id = " + clientId);
        Map map = this._heartMap;
        synchronized (map) {
            Heartbeat heart = (Heartbeat)this._heartMap.get(clientId);
            if (heart == null) {
                Trace.trace("HSSLCONF", "HeartbeatMonitor.addListenerForClient:  client id not found");
                this._pendingAddListeners.put(clientId, listener);
            } else {
                Trace.trace("HSSLCONF", "HeartbeatMonitor.addListenerForClient:  found heart for client id");
                heart.addListener(listener);
            }
        }
        Trace.trace("HSSLCONF", "<-- HeartbeatMonitor.addListenerForClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenerForClient(ContextId clientId, HeartbeatListener listener) {
        Trace.trace("HSSLCONF", "--> HeartbeatMonitor.removeListenerForClient id = " + clientId);
        Map map = this._heartMap;
        synchronized (map) {
            Heartbeat heart = (Heartbeat)this._heartMap.get(clientId);
            if (heart == null) {
                Trace.trace("HSSLCONF", "HeartbeatMonitor.removeListenerForClient:  client id not found " + clientId);
            } else {
                Trace.trace("HSSLCONF", "HeartbeatMonitor.removeListenerForClient:  found heart and removed listener");
                heart.removeListener(listener);
            }
        }
        Trace.trace("HSSLCONF", "<-- HeartbeatMonitor.removeListenerForClient");
    }
}

